/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame;

import edu.csc413.tankgame.SoundEffect;
import edu.csc413.tankgame.WallImageInfo;
import edu.csc413.tankgame.model.CushionAiTank;
import edu.csc413.tankgame.model.Entity;
import edu.csc413.tankgame.model.GameState;
import edu.csc413.tankgame.model.PlayerTank;
import edu.csc413.tankgame.model.PowerUp;
import edu.csc413.tankgame.model.Shell;
import edu.csc413.tankgame.model.Tank;
import edu.csc413.tankgame.model.Wall;
import edu.csc413.tankgame.view.MainView;
import edu.csc413.tankgame.view.RunGameView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.Map;

public class GameDriver {
    private final MainView mainView;
    private final RunGameView runGameView;
    private final GameState gameState;
    public ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("start_ac")) {
                GameDriver.this.runGame();
            } else if (e.getActionCommand().equals("exit_ac")) {
                GameDriver.this.mainView.closeGame();
            }
        }
    };
    public KeyListener keyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            GameDriver.this.gameState.setKeyCode(true, e.getKeyCode());
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                GameDriver.this.mainView.closeGame();
            }
            GameDriver.this.gameState.setKeyCode(false, e.getKeyCode());
        }
    };

    public GameDriver() {
        this.mainView = new MainView(this.actionListener, this.keyListener);
        this.runGameView = this.mainView.getRunGameView();
        this.gameState = new GameState();
    }

    public void start() {
        this.mainView.setScreen(MainView.Screen.START_MENU_SCREEN);
        SoundEffect.init();
        SoundEffect.volume = SoundEffect.Volume.LOW;
    }

    private void runGame() {
        this.mainView.setScreen(MainView.Screen.RUN_GAME_SCREEN);
        PlayerTank playerTank = new PlayerTank("player-tank", 250.0, 200.0, RunGameView.PLAYER_TANK_INITIAL_ANGLE);
        CushionAiTank aiTank = new CushionAiTank("ai-tank", 700.0, 500.0, RunGameView.AI_TANK_INITIAL_ANGLE);
        CushionAiTank aiTank2 = new CushionAiTank("ai-tank2", 700.0, 200.0, RunGameView.AI_TANK_2_INITIAL_ANGLE);
        this.gameState.addEntities(playerTank);
        this.gameState.addEntities(aiTank);
        this.gameState.addEntities(aiTank2);
        this.runGameView.addDrawableEntity("player-tank", "player-tank.png", playerTank.getX(), playerTank.getY(), playerTank.getAngle());
        this.runGameView.addDrawableEntity("ai-tank", "ai-tank.png", aiTank.getX(), aiTank.getY(), aiTank.getAngle());
        this.runGameView.addDrawableEntity("ai-tank2", "ai-tank.png", aiTank2.getX(), aiTank2.getY(), aiTank2.getAngle());
        List<WallImageInfo> wallImageInfo = WallImageInfo.readWalls();
        int i = 0;
        while (i < wallImageInfo.size()) {
            this.gameState.addWall(new Wall(wallImageInfo.get(i).getX(), wallImageInfo.get(i).getY(), 0.0));
            this.gameState.addEntities(this.gameState.getWall(i));
            this.runGameView.addDrawableEntity(this.gameState.getWall(i).getId(), wallImageInfo.get(i).getImageFile(), wallImageInfo.get(i).getX(), wallImageInfo.get(i).getY(), 0.0);
            ++i;
        }
        PowerUp powerUp = new PowerUp("star-powerup-3.png", 512.0, 384.0, RunGameView.POWER_UP_INITIAL_ANGLE);
        this.gameState.addEntities(powerUp);
        this.runGameView.addDrawableEntity(powerUp.getId(), "star-powerup-3.png", powerUp.getX(), powerUp.getY(), powerUp.getAngle());
        Runnable gameRunner = () -> {
            while (this.update()) {
                this.runGameView.repaint();
                try {
                    Thread.sleep(8L);
                }
                catch (InterruptedException exception) {
                    throw new RuntimeException(exception);
                }
            }
        };
        new Thread(gameRunner).start();
    }

    private boolean update() {
        for (Map.Entry<String, Entity> entry : this.gameState.getRemoveShells().entrySet()) {
            this.runGameView.addAnimation(RunGameView.SHELL_EXPLOSION_ANIMATION, 3, entry.getValue().getXBoundShellAnimation(), entry.getValue().getYBoundShellAnimation());
            this.runGameView.removeDrawableEntity(entry.getKey());
            this.gameState.getEntities().remove(entry.getValue());
        }
        this.gameState.getRemoveShells().clear();
        for (Entity entity : this.gameState.getEntities()) {
            if (entity instanceof Tank) {
                ((Tank)entity).setShellTimer();
            }
            entity.move(this.gameState);
        }
        for (Entity entity : this.gameState.getEntities()) {
            if (entity instanceof Tank) {
                if (entity.getX() < 30.0) {
                    entity.setNewX(30.0);
                }
                if (entity.getX() > GameState.TANK_X_UPPER_BOUND) {
                    entity.setNewX(GameState.TANK_X_UPPER_BOUND);
                }
                if (entity.getY() < 30.0) {
                    entity.setNewY(30.0);
                }
                if (!(entity.getY() > GameState.TANK_Y_UPPER_BOUND)) continue;
                entity.setNewY(GameState.TANK_Y_UPPER_BOUND);
                continue;
            }
            if (!entity.getId().contains("shell-")) continue;
            if (entity.getX() < -10.0) {
                this.gameState.addRemoveShells(entity.getId(), entity);
                continue;
            }
            if (entity.getX() > GameState.SHELL_X_UPPER_BOUND) {
                this.gameState.addRemoveShells(entity.getId(), entity);
                continue;
            }
            if (entity.getY() < -10.0) {
                this.gameState.addRemoveShells(entity.getId(), entity);
                continue;
            }
            if (!(entity.getY() > GameState.SHELL_Y_UPPER_BOUND)) continue;
            this.gameState.addRemoveShells(entity.getId(), entity);
        }
        int i = 0;
        while (i < this.gameState.getEntities().size()) {
            int j = i + 1;
            while (j < this.gameState.getEntities().size()) {
                if (this.entitiesOverlap(this.gameState.getEntities().get(i), this.gameState.getEntities().get(j))) {
                    this.handleCollision(this.gameState.getEntities().get(i), this.gameState.getEntities().get(j));
                }
                ++j;
            }
            ++i;
        }
        for (Entity entity : this.gameState.getRemoveTanksWalls()) {
            if (entity.getId().equals("player-tank") || entity.getId().equals("ai-tank")) {
                this.gameState.clearEntities();
                this.runGameView.reset();
                this.mainView.setScreen(MainView.Screen.END_MENU_SCREEN);
                return false;
            }
            this.gameState.getEntities().remove(entity);
            this.runGameView.removeDrawableEntity(entity.getId());
            if (!(entity instanceof PowerUp)) {
                this.runGameView.addAnimation(RunGameView.BIG_EXPLOSION_ANIMATION, 4, entity.getXBoundAnimation(), entity.getYBoundAnimation());
            }
            if (!(entity instanceof Tank)) continue;
            SoundEffect.TANKDEATH.play();
        }
        this.gameState.getRemoveTanksWalls().clear();
        for (Entity temp : this.gameState.getTempEntities()) {
            this.runGameView.addDrawableEntity(temp.getId(), "shell.png", temp.getX(), temp.getY(), temp.getAngle());
            this.gameState.addEntities(temp);
        }
        this.gameState.getTempEntities().clear();
        for (Entity entity : this.gameState.getEntities()) {
            this.runGameView.setDrawableEntityLocationAndAngle(entity.getId(), entity.getX(), entity.getY(), entity.getAngle());
        }
        return true;
    }

    private boolean entitiesOverlap(Entity entity1, Entity entity2) {
        return entity1.getX() < entity2.getXBound() && entity1.getXBound() > entity2.getX() && entity1.getY() < entity2.getYBound() && entity1.getYBound() > entity2.getY();
    }

    private void handleCollision(Entity entity1, Entity entity2) {
        if (entity1 instanceof Tank && entity2 instanceof Tank) {
            this.tankVTank(entity1, entity2);
        } else if (entity1 instanceof Tank && entity2 instanceof Shell) {
            if (!entity1.getId().equals(((Shell)entity2).getTankID())) {
                this.tankVShell(entity1, entity2);
                SoundEffect.EXPLODE.play();
            }
        } else if (entity1 instanceof Shell && entity2 instanceof Tank) {
            if (!entity2.getId().equals(((Shell)entity1).getTankID())) {
                this.shellVTank(entity1, entity2);
                SoundEffect.EXPLODE.play();
            }
        } else if (entity1 instanceof Shell && entity2 instanceof Shell) {
            this.shellVShell(entity1, entity2);
            SoundEffect.EXPLODE.play();
        } else if (entity1 instanceof Tank && entity2 instanceof Wall) {
            this.tankVWall(entity1, entity2);
        } else if (entity1 instanceof Wall && entity2 instanceof Tank) {
            this.wallVTank(entity1, entity2);
        } else if (entity1 instanceof Shell && entity2 instanceof Wall || entity1 instanceof Wall && entity2 instanceof Shell) {
            this.shellVWall(entity1, entity2);
        } else if (entity1 instanceof PlayerTank && entity2 instanceof PowerUp || entity1 instanceof PowerUp && entity2 instanceof PlayerTank) {
            if (entity1 instanceof PlayerTank) {
                this.tankVPowerUp(entity1, entity2);
            } else {
                this.tankVPowerUp(entity2, entity1);
            }
        }
    }

    private void tankVTank(Entity entity1, Entity entity2) {
        double left = entity1.getXBound() - entity2.getX();
        double right = entity2.getXBound() - entity1.getX();
        double up = entity1.getYBound() - entity2.getY();
        double down = entity2.getYBound() - entity1.getY();
        double min = 0.0;
        min = Math.min(Math.min(Math.min(left, right), down), up);
        if (min == left) {
            entity1.setNewX(entity1.getX() - min / 2.0);
            entity2.setNewX(entity2.getX() + min / 2.0);
        } else if (min == right) {
            entity1.setNewX(entity1.getX() + min / 2.0);
            entity2.setNewX(entity2.getX() - min / 2.0);
        } else if (min == up) {
            entity1.setNewY(entity1.getX() - min / 2.0);
            entity2.setNewY(entity2.getX() + min / 2.0);
        } else if (min == down) {
            entity1.setNewY(entity1.getX() + min / 2.0);
            entity2.setNewY(entity2.getX() - min / 2.0);
        }
    }

    private void tankVShell(Entity entity1, Entity entity2) {
        this.gameState.addRemoveShells(entity2.getId(), entity2);
        entity1.reduceHealth();
        if (entity1 instanceof PlayerTank) {
            if (entity1.getHealth() == 2) {
                SoundEffect.PLAYERLIFE1.play();
            } else if (entity1.getHealth() == 1) {
                SoundEffect.PLAYERLIFE2.play();
            }
        }
        if (entity1.getHealth() == 0) {
            this.gameState.addRemoveTankWalls(entity1);
        }
    }

    private void shellVTank(Entity entity1, Entity entity2) {
        this.gameState.addRemoveShells(entity1.getId(), entity1);
        entity2.reduceHealth();
        if (entity2 instanceof PlayerTank) {
            if (entity2.getHealth() == 2) {
                SoundEffect.PLAYERLIFE1.play();
            } else if (entity1.getHealth() == 1) {
                SoundEffect.PLAYERLIFE2.play();
            }
        }
        if (entity2.getHealth() == 0) {
            this.gameState.addRemoveTankWalls(entity2);
        }
    }

    private void shellVShell(Entity entity1, Entity entity2) {
        this.gameState.addRemoveShells(entity1.getId(), entity1);
        this.gameState.addRemoveShells(entity2.getId(), entity2);
    }

    private void tankVWall(Entity entity1, Entity entity2) {
        double left = entity1.getXBound() - entity2.getX();
        double right = entity2.getXBound() - entity1.getX();
        double up = entity1.getYBound() - entity2.getY();
        double down = entity2.getYBound() - entity1.getY();
        double min = Math.min(Math.min(Math.min(left, right), down), up);
        if (min == left) {
            entity1.setNewX(entity1.getX() - min);
        } else if (min == right) {
            entity1.setNewX(entity1.getX() + min);
        } else if (min == up) {
            entity1.setNewY(entity1.getY() - min);
        } else if (min == down) {
            entity1.setNewY(entity1.getY() + min);
        }
    }

    private void wallVTank(Entity entity1, Entity entity2) {
        double left = entity1.getXBound() - entity2.getX();
        double right = entity2.getXBound() - entity1.getX();
        double up = entity1.getYBound() - entity2.getY();
        double down = entity2.getYBound() - entity1.getY();
        double min = Math.min(Math.min(Math.min(left, right), down), up);
        if (min == left) {
            entity2.setNewX(entity2.getX() + min);
        } else if (min == right) {
            entity2.setNewX(entity2.getX() - min);
        } else if (min == up) {
            entity2.setNewY(entity2.getY() - min);
        } else if (min == down) {
            entity2.setNewY(entity2.getY() + min);
        }
    }

    private void shellVWall(Entity entity1, Entity entity2) {
        if (entity1 instanceof Shell) {
            this.gameState.addRemoveShells(entity1.getId(), entity1);
            ((Wall)entity2).reduceHealth();
            if (entity2.getHealth() == 0) {
                this.gameState.addRemoveTankWalls(entity2);
            }
            SoundEffect.EXPLODE2.play();
        } else {
            this.gameState.addRemoveShells(entity2.getId(), entity2);
            ((Wall)entity1).reduceHealth();
            if (entity1.getHealth() == 0) {
                this.gameState.addRemoveTankWalls(entity1);
            }
            SoundEffect.EXPLODE2.play();
        }
    }

    private void tankVPowerUp(Entity entity1, Entity entity2) {
        this.gameState.addRemoveTankWalls(entity2);
        ((PlayerTank)entity1).setHealth();
    }

    public static void main(String[] args) {
        GameDriver gameDriver = new GameDriver();
        gameDriver.start();
    }
}

