/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public enum SoundEffect {
    EXPLODE("explosion1.wav"),
    EXPLODE2("explosion2.wav"),
    TANKDEATH("tankdeath.wav"),
    PLAYERLIFE1("playerLife1.wav"),
    PLAYERLIFE2("playerLife2.wav");

    public static Volume volume;
    private Clip clip;

    static {
        volume = Volume.LOW;
    }

    private SoundEffect(String soundFileName) {
        try {
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(soundFileName);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(url);
            this.clip = AudioSystem.getClip();
            this.clip.open(audioInputStream);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void play() {
        if (volume != Volume.MUTE) {
            if (this.clip.isRunning()) {
                this.clip.stop();
            }
            this.clip.setFramePosition(0);
            this.clip.start();
        }
    }

    static void init() {
        SoundEffect.values();
    }

    public static enum Volume {
        MUTE,
        LOW,
        MEDIUM,
        HIGH;

    }
}

