/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class WallImageInfo {
    private static final String WALL_IMAGE_FILE_PREFIX = "wall-";
    private static final String WALL_IMAGE_FILE_SUFFIX = ".png";
    private static final String WALLS_SETUP_FILE = "walls.txt";
    private static final double WALL_WIDTH = 32.0;
    private static final double WALL_HEIGHT = 32.0;
    private final String imageFile;
    private final double x;
    private final double y;

    private WallImageInfo(String imageFile, double x, double y) {
        this.imageFile = imageFile;
        this.x = x;
        this.y = y;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public static List<WallImageInfo> readWalls() {
        ArrayList walls;
        URL fileUrl = WallImageInfo.class.getClassLoader().getResource(WALLS_SETUP_FILE);
        if (fileUrl == null) {
            throw new RuntimeException("Unable to find the resource: walls.txt");
        }
        try {
            Path tempFile = WallImageInfo.copyToTempFile(fileUrl, ".txt");
            try {
                walls = Files.lines(Paths.get(tempFile.toUri().toURL().toURI())).map(WallImageInfo::lineToList).collect(Collectors.toCollection(ArrayList::new));
            }
            catch (IOException | URISyntaxException exception) {
                throw new RuntimeException(exception);
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        ArrayList<WallImageInfo> wallImageInfos = new ArrayList<WallImageInfo>();
        int row = 0;
        while (row < walls.size()) {
            int col = 0;
            while (col < ((ArrayList)walls.get(row)).size()) {
                if ((Integer)((ArrayList)walls.get(row)).get(col) != 0) {
                    double x = (double)col * 32.0;
                    double y = (double)row * 32.0;
                    wallImageInfos.add(new WallImageInfo(String.format("%s%d%s", WALL_IMAGE_FILE_PREFIX, ((ArrayList)walls.get(row)).get(col), WALL_IMAGE_FILE_SUFFIX), x, y));
                }
                ++col;
            }
            ++row;
        }
        return wallImageInfos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Path copyToTempFile(URL url, String suffix) throws IOException {
        Path tempFile = Files.createTempFile(null, suffix, new FileAttribute[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream in = url.openStream();
            try {
                try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
                    int bytesRead;
                    byte[] buffer = new byte[10240];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        out.write(buffer, 0, bytesRead);
                    }
                    in.close();
                    out.close();
                }
                if (in == null) return tempFile;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return tempFile;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static ArrayList<Integer> lineToList(String line) {
        return Arrays.stream(line.split("\\s")).map(Integer::parseInt).collect(Collectors.toCollection(ArrayList::new));
    }
}

