/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.model;

import edu.csc413.tankgame.model.Entity;
import edu.csc413.tankgame.model.GameState;
import edu.csc413.tankgame.model.Tank;

public class CushionAiTank
extends Tank {
    private int cushionAiHealth = 3;

    public CushionAiTank(String id, double x, double y, double angle) {
        super(id, x, y, angle);
    }

    @Override
    public void move(GameState gameState) {
        Entity playerTank = gameState.getEntity("player-tank");
        double dx = playerTank.getX() - this.getX();
        double dy = playerTank.getY() - this.getY();
        double angleToPlayer = Math.atan2(dy, dx);
        double angleDifference = this.getAngle() - angleToPlayer;
        if ((angleDifference -= Math.floor(angleDifference / Math.toRadians(360.0) + 0.5) * Math.toRadians(360.0)) < -Math.toRadians(3.0)) {
            this.turnRight();
        } else if (angleDifference > Math.toRadians(3.0)) {
            this.turnLeft();
        }
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance > 400.0) {
            this.moveForward();
        } else if (distance < 200.0) {
            this.moveBackward();
        }
        if (this.getShellTimer() == 0) {
            this.shoot(gameState);
        }
    }

    @Override
    public double getWidth() {
        return 55.0;
    }

    @Override
    public double getHeight() {
        return 55.0;
    }

    @Override
    public int getHealth() {
        return this.cushionAiHealth;
    }

    @Override
    public void reduceHealth() {
        --this.cushionAiHealth;
    }

    @Override
    public void setHealth() {
    }
}

