/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.model;

import edu.csc413.tankgame.model.GameState;

public abstract class Entity {
    private static final double TURN_SPEED = Math.toRadians(3.0);
    private final String id;
    private double x;
    private double y;
    private double angle;

    public Entity(String id, double x, double y, double angle) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.angle = angle;
    }

    public String getId() {
        return this.id;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getAngle() {
        return this.angle;
    }

    public abstract void move(GameState var1);

    public abstract double getSpeed();

    public void setNewX(double x) {
        this.x = x;
    }

    public void setNewY(double y) {
        this.y = y;
    }

    public abstract double getWidth();

    public abstract double getHeight();

    public double getXBound() {
        return this.getX() + this.getWidth();
    }

    public double getYBound() {
        return this.getY() + this.getHeight();
    }

    public double getXBoundAnimation() {
        return this.getX() + 32.0;
    }

    public double getYBoundAnimation() {
        return this.getY() + 32.0;
    }

    public double getXBoundShellAnimation() {
        return this.getX() + 16.0;
    }

    public double getYBoundShellAnimation() {
        return this.getY() + 16.0;
    }

    public abstract int getHealth();

    public abstract void reduceHealth();

    public abstract void setHealth();

    protected void moveForward() {
        this.x += this.getSpeed() * Math.cos(this.angle);
        this.y += this.getSpeed() * Math.sin(this.angle);
    }

    protected void moveBackward() {
        this.x -= this.getSpeed() * Math.cos(this.angle);
        this.y -= this.getSpeed() * Math.sin(this.angle);
    }

    protected void turnLeft() {
        this.angle -= TURN_SPEED;
    }

    protected void turnRight() {
        this.angle += TURN_SPEED;
    }
}

