/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.model;

import edu.csc413.tankgame.model.Entity;
import edu.csc413.tankgame.model.Wall;
import edu.csc413.tankgame.view.RunGameView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GameState {
    public static final double TANK_X_LOWER_BOUND = 30.0;
    public static final double TANK_X_UPPER_BOUND = (double)RunGameView.SCREEN_DIMENSIONS.width - 100.0;
    public static final double TANK_Y_LOWER_BOUND = 30.0;
    public static final double TANK_Y_UPPER_BOUND = (double)RunGameView.SCREEN_DIMENSIONS.height - 120.0;
    public static final double SHELL_X_LOWER_BOUND = -10.0;
    public static final double SHELL_X_UPPER_BOUND = RunGameView.SCREEN_DIMENSIONS.width;
    public static final double SHELL_Y_LOWER_BOUND = -10.0;
    public static final double SHELL_Y_UPPER_BOUND = RunGameView.SCREEN_DIMENSIONS.height;
    public static final String PLAYER_TANK_ID = "player-tank";
    public static final String AI_TANK_ID = "ai-tank";
    public static final String AI_TANK_ID_2 = "ai-tank2";
    private final List<Entity> entities = new ArrayList<Entity>();
    private final List<Entity> tempEntities = new ArrayList<Entity>();
    private final Map<String, Entity> removeShells = new HashMap<String, Entity>();
    private final List<Wall> walls = new ArrayList<Wall>();
    private final List<Entity> removeTanksWalls = new ArrayList<Entity>();
    private boolean k = false;
    private int key;

    public void addEntities(Entity entity) {
        this.entities.add(entity);
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public Entity getEntity(String id) {
        for (Entity entity : this.entities) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    public void addTempEntities(Entity entity) {
        this.tempEntities.add(entity);
    }

    public List<Entity> getTempEntities() {
        return this.tempEntities;
    }

    public boolean deleteTempEntity(Entity entity) {
        return this.tempEntities.remove(entity);
    }

    public void addRemoveShells(String id, Entity entity) {
        this.removeShells.put(id, entity);
    }

    public Map<String, Entity> getRemoveShells() {
        return this.removeShells;
    }

    public void addWall(Wall wall) {
        this.walls.add(wall);
    }

    public Wall getWall(int index) {
        return this.walls.get(index);
    }

    public void addRemoveTankWalls(Entity entity) {
        this.removeTanksWalls.add(entity);
    }

    public List<Entity> getRemoveTanksWalls() {
        return this.removeTanksWalls;
    }

    public void setKeyCode(boolean check, int keyCode) {
        this.k = check;
        this.key = keyCode;
    }

    public boolean upPressed() {
        return this.k && this.key == 87;
    }

    public boolean downPressed() {
        return this.k && this.key == 83;
    }

    public boolean leftPressed() {
        return this.k && this.key == 65;
    }

    public boolean rightPressed() {
        return this.k && this.key == 68;
    }

    public boolean fireShell() {
        return this.k && this.key == 32;
    }

    public void clearEntities() {
        this.entities.clear();
        this.tempEntities.clear();
        this.removeTanksWalls.clear();
        this.removeShells.clear();
        this.walls.clear();
    }
}

