/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.model;

import edu.csc413.tankgame.model.GameState;
import edu.csc413.tankgame.model.Tank;

public class PlayerTank
extends Tank {
    private int playerHealth = 3;

    public PlayerTank(String id, double x, double y, double angle) {
        super(id, x, y, angle);
    }

    @Override
    public void move(GameState gameState) {
        if (gameState.upPressed()) {
            this.moveForward();
        }
        if (gameState.downPressed()) {
            this.moveBackward();
        }
        if (gameState.leftPressed()) {
            this.turnLeft();
        }
        if (gameState.rightPressed()) {
            this.turnRight();
        }
        if (gameState.fireShell() && this.getShellTimer() == 0) {
            this.shoot(gameState);
        }
    }

    @Override
    public double getWidth() {
        return 55.0;
    }

    @Override
    public double getHeight() {
        return 55.0;
    }

    @Override
    public int getHealth() {
        return this.playerHealth;
    }

    @Override
    public void reduceHealth() {
        --this.playerHealth;
    }

    @Override
    public void setHealth() {
        this.playerHealth = 3;
    }
}

