/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.model;

import edu.csc413.tankgame.model.Entity;
import edu.csc413.tankgame.model.GameState;
import edu.csc413.tankgame.model.Shell;

public abstract class Tank
extends Entity {
    private static final double MOVEMENT_SPEED = 2.0;
    private int shellTimer = 0;

    public Tank(String id, double x, double y, double angle) {
        super(id, x, y, angle);
    }

    @Override
    public double getSpeed() {
        return 2.0;
    }

    protected void shoot(GameState gameState) {
        this.shellTimer = 200;
        Shell shell = new Shell(this.getId(), this.getShellX(), this.getShellY(), this.getAngle());
        gameState.addTempEntities(shell);
        shell.setTankID(this.getId());
    }

    public int getShellTimer() {
        return this.shellTimer;
    }

    public void setShellTimer() {
        if (this.getShellTimer() > 0) {
            --this.shellTimer;
        }
    }

    private double getShellX() {
        return this.getX() + 30.0 * (Math.cos(this.getAngle()) + 0.5);
    }

    private double getShellY() {
        return this.getY() + 30.0 * (Math.sin(this.getAngle()) + 0.5);
    }
}

