/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.view;

import edu.csc413.tankgame.view.AnimationResource;
import java.awt.image.BufferedImage;
import java.util.Optional;

class Animation {
    private final AnimationResource animationResource;
    private final int frameDelay;
    private final double x;
    private final double y;
    private int currentFrame = 0;
    private int counter = 0;

    Animation(AnimationResource animationResource, int frameDelay, double x, double y) {
        this.animationResource = animationResource;
        this.frameDelay = frameDelay;
        this.x = x;
        this.y = y;
    }

    double getX() {
        return this.x;
    }

    double getY() {
        return this.y;
    }

    Optional<BufferedImage> getImage() {
        if (this.currentFrame == this.animationResource.getNumFrames()) {
            return Optional.empty();
        }
        BufferedImage bufferedImage = this.animationResource.getFrame(this.currentFrame);
        ++this.counter;
        if (this.counter >= this.frameDelay) {
            this.counter = 0;
            ++this.currentFrame;
        }
        return Optional.of(bufferedImage);
    }
}

