/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.view;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

class AnimationResource {
    private final BufferedImage[] frames;

    AnimationResource(String imagePrefix, String imageSuffix, int numFrames) {
        this.frames = new BufferedImage[numFrames];
        int i = 0;
        while (i < numFrames) {
            String imageFile = String.format("%s%d%s", imagePrefix, i, imageSuffix);
            URL imageUrl = this.getClass().getClassLoader().getResource(imageFile);
            if (imageUrl == null) {
                throw new RuntimeException(String.format("Couldn't find the file '%s'", imageFile));
            }
            try {
                this.frames[i] = ImageIO.read(imageUrl);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            ++i;
        }
    }

    int getNumFrames() {
        return this.frames.length;
    }

    BufferedImage getFrame(int index) {
        return this.frames[index];
    }
}

