/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.view;

import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

class DrawableEntity {
    private static final Map<String, BufferedImage> imageCache = new HashMap<String, BufferedImage>();
    private final BufferedImage entityImage;
    private final AffineTransform affineTransform;

    DrawableEntity(String imageFile) {
        if (!imageCache.containsKey(imageFile)) {
            URL imageUrl = this.getClass().getClassLoader().getResource(imageFile);
            if (imageUrl == null) {
                throw new RuntimeException("blah");
            }
            try {
                imageCache.put(imageFile, ImageIO.read(imageUrl));
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
        this.entityImage = imageCache.get(imageFile);
        this.affineTransform = new AffineTransform();
    }

    BufferedImage getEntityImage() {
        return this.entityImage;
    }

    AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    void setLocationAndAngle(double x, double y, double angle) {
        this.affineTransform.setToTranslation(x, y);
        this.affineTransform.rotate(angle, (double)this.entityImage.getWidth() / 2.0, (double)this.entityImage.getHeight() / 2.0);
    }
}

