/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.view;

import edu.csc413.tankgame.view.RunGameView;
import edu.csc413.tankgame.view.StartMenuView;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MainView {
    private final JFrame mainJFrame = new JFrame();
    private final JPanel mainPanel;
    private final CardLayout mainPanelLayout;
    private final RunGameView runGameView;

    public MainView(ActionListener actionListener, KeyListener keyListener) {
        this.mainJFrame.setVisible(false);
        this.mainJFrame.setResizable(false);
        this.mainJFrame.setTitle("Tank Wars");
        this.mainJFrame.setLocationRelativeTo(null);
        this.mainJFrame.setDefaultCloseOperation(3);
        this.mainJFrame.addKeyListener(keyListener);
        this.mainPanel = new JPanel();
        this.mainPanelLayout = new CardLayout();
        this.mainPanel.setLayout(this.mainPanelLayout);
        StartMenuView startMenuView = new StartMenuView("Start Game", actionListener);
        this.mainPanel.add((Component)startMenuView, Screen.START_MENU_SCREEN.getScreenName());
        StartMenuView endMenuView = new StartMenuView("Restart Game", actionListener);
        this.mainPanel.add((Component)endMenuView, Screen.END_MENU_SCREEN.getScreenName());
        this.runGameView = new RunGameView();
        this.mainPanel.add((Component)this.runGameView, Screen.RUN_GAME_SCREEN.getScreenName());
        this.mainJFrame.add(this.mainPanel);
    }

    public RunGameView getRunGameView() {
        return this.runGameView;
    }

    public void setScreen(Screen screen) {
        this.mainJFrame.setVisible(false);
        if (screen == Screen.START_MENU_SCREEN || screen == Screen.END_MENU_SCREEN) {
            Dimension screenSize = StartMenuView.SCREEN_DIMENSIONS;
            this.mainJFrame.setSize(screenSize);
            this.mainJFrame.validate();
            this.mainJFrame.setLocationRelativeTo(null);
        } else {
            Dimension screenSize = RunGameView.SCREEN_DIMENSIONS;
            this.mainJFrame.setSize(screenSize);
            this.mainJFrame.validate();
            this.mainJFrame.setLocationRelativeTo(null);
        }
        this.mainPanelLayout.show(this.mainPanel, screen.getScreenName());
        this.mainJFrame.setVisible(true);
    }

    public void closeGame() {
        this.mainJFrame.dispatchEvent(new WindowEvent(this.mainJFrame, 201));
    }

    public static enum Screen {
        START_MENU_SCREEN("start"),
        RUN_GAME_SCREEN("game"),
        END_MENU_SCREEN("end");

        private final String screenName;

        private Screen(String screenName) {
            this.screenName = screenName;
        }

        public String getScreenName() {
            return this.screenName;
        }
    }
}

