/*
 * Decompiled with CFR 0.152.
 */
package edu.csc413.tankgame.view;

import edu.csc413.tankgame.view.Animation;
import edu.csc413.tankgame.view.AnimationResource;
import edu.csc413.tankgame.view.DrawableEntity;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import javax.swing.JPanel;

public class RunGameView
extends JPanel {
    public static final Dimension SCREEN_DIMENSIONS = new Dimension(1024, 768);
    public static final String PLAYER_TANK_IMAGE_FILE = "player-tank.png";
    public static final double PLAYER_TANK_INITIAL_X = 250.0;
    public static final double PLAYER_TANK_INITIAL_Y = 200.0;
    public static final double PLAYER_TANK_INITIAL_ANGLE = Math.toRadians(0.0);
    public static final String AI_TANK_IMAGE_FILE = "ai-tank.png";
    public static final double AI_TANK_INITIAL_X = 700.0;
    public static final double AI_TANK_INITIAL_Y = 500.0;
    public static final double AI_TANK_INITIAL_ANGLE = Math.toRadians(180.0);
    public static final double AI_TANK_2_INITIAL_X = 700.0;
    public static final double AI_TANK_2_INITIAL_Y = 200.0;
    public static final double AI_TANK_2_INITIAL_ANGLE = Math.toRadians(180.0);
    public static final String SHELL_IMAGE_FILE = "shell.png";
    private static final String SHELL_EXPLOSION_FILE_PREFIX = "shell-explosion-";
    private static final String SHELL_EXPLOSION_FILE_SUFFIX = ".png";
    public static final AnimationResource SHELL_EXPLOSION_ANIMATION = new AnimationResource("shell-explosion-", ".png", 6);
    public static final int SHELL_EXPLOSION_FRAME_DELAY = 3;
    public static final double SHELL_EXPLOSION_WIDTH = 32.0;
    public static final double SHELL_EXPLOSION_HEIGHT = 32.0;
    private static final String BIG_EXPLOSION_FILE_PREFIX = "big-explosion-";
    private static final String BIG_EXPLOSION_FILE_SUFFIX = ".png";
    public static final AnimationResource BIG_EXPLOSION_ANIMATION = new AnimationResource("big-explosion-", ".png", 7);
    public static final int BIG_EXPLOSION_FRAME_DELAY = 4;
    public static final double BIG_EXPLOSION_WIDTH = 64.0;
    public static final double BIG_EXPLOSION_HEIGHT = 64.0;
    public static final String POWER_UP_IMAGE_FILE = "star-powerup-3.png";
    public static final double POWER_UP_INITIAL_X = 512.0;
    public static final double POWER_UP_INITIAL_Y = 384.0;
    public static final double POWER_UP_INITIAL_ANGLE = Math.toRadians(0.0);
    private final BufferedImage worldImage;
    private final Map<String, DrawableEntity> drawableEntitiesById = new HashMap<String, DrawableEntity>();
    private final List<Animation> animations = new LinkedList<Animation>();

    public RunGameView() {
        this.worldImage = new BufferedImage(RunGameView.SCREEN_DIMENSIONS.width, RunGameView.SCREEN_DIMENSIONS.height, 1);
        this.setBackground(Color.BLACK);
    }

    public void reset() {
        this.drawableEntitiesById.clear();
    }

    public void addDrawableEntity(String id, String entityImageFile, double initialX, double initialY, double initialAngle) {
        DrawableEntity drawableEntity = new DrawableEntity(entityImageFile);
        drawableEntity.setLocationAndAngle(initialX, initialY, initialAngle);
        this.drawableEntitiesById.put(id, drawableEntity);
    }

    public void removeDrawableEntity(String id) {
        this.drawableEntitiesById.remove(id);
    }

    public void setDrawableEntityLocationAndAngle(String id, double x, double y, double angle) {
        this.drawableEntitiesById.get(id).setLocationAndAngle(x, y, angle);
    }

    public void addAnimation(AnimationResource animationResource, int frameDelay, double x, double y) {
        this.animations.add(new Animation(animationResource, frameDelay, x, y));
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D buffer = this.worldImage.createGraphics();
        buffer.setColor(Color.BLACK);
        buffer.fillRect(0, 0, RunGameView.SCREEN_DIMENSIONS.width, RunGameView.SCREEN_DIMENSIONS.height);
        for (DrawableEntity drawableEntity : this.drawableEntitiesById.values()) {
            buffer.drawImage(drawableEntity.getEntityImage(), drawableEntity.getAffineTransform(), null);
        }
        ListIterator<Animation> animationIterator = this.animations.listIterator();
        while (animationIterator.hasNext()) {
            Animation animation = animationIterator.next();
            Optional<BufferedImage> nextImage = animation.getImage();
            if (nextImage.isPresent()) {
                buffer.drawImage((Image)nextImage.get(), (int)animation.getX(), (int)animation.getY(), null);
                continue;
            }
            animationIterator.remove();
        }
        g.drawImage(this.worldImage, 0, 0, null);
    }
}

